//
//  GSFilterPlugin.h
//  GlyphsCore
//
//  Created by Georg Seifert on 19.01.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GlyphsFilterProtocol.h>
#ifndef LIBCORE
#import <GlyphsCore/GSDialogController.h>
#import <GlyphsCore/GSGlyphViewControllerProtocol.h>
#endif
@class GSFontMaster;

#ifndef LIBCORE
@interface GSFilterPlugin : NSObject <GlyphsFilter, GSDialogDelegateProtocol>
#else
@interface GSFilterPlugin : NSObject <GlyphsFilter>
#endif
{
#ifndef LIBCORE
	/// will be set by Glyphs
	// TODO: this needs to get an underscore, but some plugins rely on it without it.
	__unsafe_unretained NSViewController<GSGlyphEditViewControllerProtocol> *controller;
#endif
	/// will be set by Glyphs
	BOOL rerun;

	/// set this up in Interface Builder or generate programmatically
	IBOutlet NSView *_view;

	/// if the plugin run is called through runFilterWithLayer: you might mant to pay attention to the current selection state.
	BOOL _checkSelection;
	/// for your internal use.
	BOOL returnValue;

	GSFontMaster *__unsafe_unretained _fontMaster;
	NSMutableArray<GSLayer *> *_layers;
	NSMutableArray<GSLayer *> *_shadowLayers;
	IBOutlet NSControl *myFirstResponder;
	GSDialogController *_dialog;
}

- (void)cancelDialog:(id)sender;

- (void)process:(id)sender;

- (NSError *)setup;

- (void)final;

@end
